<?php
if (isset($public) || isset($semRefrescamento)) {
	include_once '../modelo/venda.modelo.php';
}else {
	include_once 'modelo/venda.modelo.php';
}
  
  
class ControladorVenda 
{
  
static public function ctrAddVenda($idProduto, $preco,$precoVenda,$tipoProduto,$cumissaoFiliado,$cumissaoPlataforma,$estadoVenda,$tipoVenda)
{
 	
	if (!empty($idProduto)) 
	{
				$idVaga = addslashes($idProduto);
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = $_SESSION['ID_usuario'];
				$idFiliado = "";
				if (isset($_SESSION['Filiado'])) {
					$idFiliado = $_SESSION['Filiado'];
				}else{
					$idFiliado = "";
				}
				

				$dados = array("idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED),
				"preco" => filter_var($preco,FILTER_SANITIZE_STRIPPED),
				"precoVenda" => filter_var($precoVenda,FILTER_SANITIZE_STRIPPED),
				"tipoProduto" => filter_var($tipoProduto,FILTER_SANITIZE_STRIPPED),
				"tipoVenda" => filter_var($tipoVenda,FILTER_SANITIZE_STRIPPED),
				"cumissaoFiliado" => filter_var($cumissaoFiliado,FILTER_SANITIZE_STRIPPED),
				"cumissaoPlataforma" => filter_var($cumissaoPlataforma,FILTER_SANITIZE_STRIPPED),
				"estadoVenda" => filter_var($estadoVenda,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED),
				"idFiliado" => filter_var($idFiliado,FILTER_SANITIZE_STRIPPED),
				"idCliente" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED));
 
				$verifExistencia = ControladorVenda::ctrVerificarSeOUsuarioJaEstaFiliadoAVaga($idVaga, $idUsuario);
				if ($verifExistencia == true) 
				{ 
					$Vaga = ModeloVenda::mdlAddVenda($dados);

					if($Vaga == "ok"){ 
							echo"
					<script>
					Swal.fire({
						position: 'top-end',
						icon: 'success',
						title: 'Você foi filiado com sucesso!',
						showConfirmButton: false,
						timer: 5000
					})
					</script>
					";	
					}else{ 
						echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro:  Não foi possivel filiar-te a este produto',
								showConfirmButton: false,
								timer: 5000
							})
						</script>";
						
					}
				 }else
				{
					echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Você já esta filiado a este produto',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					";
				} 

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}
}


static public function ctrVerificarSeOUsuarioJaEstaFiliadoAVaga($idProduto, $idCliente){

	$Vaga = ModeloVenda::mdlMostrarVendasPoridVagaEIdCliente($idProduto, $idCliente);
	if (empty($Vaga)) {
		return true;
	}
	else {
		return false;
	}
}

   
static public function ctrMostrarTodasVagas(){ 

	$Vaga = ModeloVaga::mdlMostrarTodasVagas();
	return $Vaga;
	
}
 
static public function ctrMostrarVagaPoridVaga($idVaga){
	$Vaga = ModeloVaga::mdlMostrarVagaPoridVaga($idVaga);
	return $Vaga;
}

static public function ctrMostrarTodasVendasDoAfiliadoPorIdFiliado($idFiliado){
	$Vaga = ModeloVenda::mdlMostrarTodasVendasDoAfiliadoPorIdFiliado($idFiliado);
	return $Vaga;
}

static public function ctrMostrarTodasVendasDoAfiliadoPeloIdVagaEPeloIdUsurario($idVaga, $idFiliado){
	$Vaga = ModeloVenda::mdlMostrarTodasVendasDoAfiliadoPeloIdVagaEPeloIdUsurario($idVaga, $idFiliado);
	return $Vaga;
}

static public function ctrMostrarTodasVendasDoProdutoPeloIdVaga($idVaga){
	$Vaga = ModeloVenda::mdlMostrarTodasVendasDoProdutoPeloIdVaga($idVaga);
	return $Vaga;
}

static public function ctrContarTotalVendasDoFiliado($idVaga, $idFiliado){
	$Vaga = ModeloVenda::mdlMostrarTodasVendasDoAfiliadoPeloIdVagaEPeloIdUsurario($idVaga, $idFiliado);
	return count($Vaga);
}


static public function ctrTotalGanhoEmVendasComAfiiadoPorIdVagaEIdFiliado($idVaga, $idFiliado){
	$totalGanho = 0;
	$Venda = ModeloVenda::mdlMostrarTodasVendasDoAfiliadoPeloIdVagaEPeloIdUsurario($idVaga, $idFiliado);
	foreach ($Venda as $key => $value) {
		$totalGanho = $totalGanho + ($value["precoVenda"]-($value["cumissaoFiliado"]+$value["cumissaoPlataforma"]));
	}
	return $totalGanho;
}

static public function ctrTotalGanhoEmCumissaoDoAfiiadoPorIdVagaEIdFiliado($idVaga, $idFiliado){
	$totalGanho = 0;
	$Venda = ModeloVenda::mdlMostrarTodasVendasDoAfiliadoPeloIdVagaEPeloIdUsurario($idVaga, $idFiliado);
	foreach ($Venda as $key => $value) {
		$totalGanho = $totalGanho + ($value["cumissaoFiliado"]);
	}
	return $totalGanho;
}

	static public function ctrEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado){

		$Vaga = ModeloVaga::mdlEditarPrecoDoCertificadoPorIdVaga($idVaga, $precoCertificado);

		return $Vaga;

	}

	static public function ctrEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado){

		$Vaga = ModeloVaga::mdlEditarModeloDoCertificadoPorIdVaga($idVaga, $idModeloCertificado);

		return $Vaga;

	}
 
	static public function ctrActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso, $id){  

		$Vaga = ModeloUsuario::mdlActualizarDadosUsuarioprofessors(addslashes($nome), addslashes($bi_nif), addslashes($nivelDeAcesso),addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarImagemPerfilUsuario($imagem,$id){

		$Vaga = ModeloUsuario::mdlActualizarImagemPerfilUsuario($imagem,addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarCodigoParaReporSenha($idUsuario, $codigo){

		$Vaga = ModeloUsuario::mdlActualizarCodigoParaReporSenha($idUsuario, $codigo);
		return $Vaga;

	}
 
	static public function ctrActualizarSenhaUsuario($senhaAntiga,$id, $senha){

		$Vaga = ModeloUsuario::mdlActualizarSenhaUsuario(addslashes($senhaAntiga),addslashes($id), md5(addslashes($senha)));
		return $Vaga;

	}

	static public function ctrActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$Vaga = ModeloUsuario::mdlActualizarReporSenhaUsuario(md5(addslashes($senha)),$id,$codigoParaReporSenha);
		return $Vaga;

	}

	static public function ctrDeletarUsuario($id){

		$Vaga = ModeloUsuario::mdlDeletarUsuario(addslashes($id));
		return $Vaga;

	}

}

?>